
/**
 ******************************************************************************
 *
 * @file        MG32x02z_DS1621_API.h
 * @brief       This file contains all the functions prototypes for the DS1621 
 *              firmware library.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef _MG32x02z_DS1621_API_
#define _MG32x02z_DS1621_API_


/* Includes ------------------------------------------------------------------*/
#include "MG32x02z_I2C_DRV.h"
#include "Sample_I2C_ByteMode.h"
#include "MG32x02z_GPIO_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/** @defgroup DS1621 control item 
  * @{
  */  
#define IC_Addr             0x02            // A2=0 A1=0 A0=1
#define IC_Read             0x01
#define IC_Write            0x00
#define ADDRESS_BYTE_READ   0x90|IC_Addr|IC_Read
#define ADDRESS_BYTE_WRITE  0x90|IC_Addr|IC_Write

/* TEMPERATURE CONVERSION COMMANDS --------------------------------------------*/
#define Read_Temperature    0xAA
#define Read_Counter        0xA8
#define Read_Slope          0xA9
#define Start_Convert_T     0xEE
#define Stop_Convert_T      0x22

/* THERMOSTAT COMMANDS -------------------------------------------------------*/
#define Access_TH           0xA1
#define Access_TL           0xA2
#define Access_Config       0xAC

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void API_DS1621_Init(void);
uint16_t API_DS1621_GetTemperature(void);

/* I2C management functions ***************************************************/
SMP_Return Sample_I2C_ByteMode_Init(Sample_I2C_HandleTypeDef *SI2C);
SMP_Return Sample_I2C_ByteMode_MasterReceive(Sample_I2C_HandleTypeDef *SI2C, uint16_t DevAddress, uint8_t *pBuffer, uint16_t Size);
void Sample_I2C_ByteMode_Handle(Sample_I2C_HandleTypeDef *SI2C);
SMP_Return Sample_I2C_Enable_Listen(Sample_I2C_HandleTypeDef *SI2C);
SMP_Return Sample_I2C_IsDeviceReady(Sample_I2C_HandleTypeDef *SI2C, uint16_t DevAddress, uint32_t Trials);
void Sample_I2C_Delay(uint32_t Delay);
SMP_Return Sample_I2C_ByteMode_MasterTransmit(Sample_I2C_HandleTypeDef *SI2C, uint16_t DevAddress, uint8_t *pBuffer, uint16_t Size);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

#endif


